<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="html" indent="yes" encoding="UTF-8" />
    
    <xsl:template match="/">
        <!-- Simply generate an HTML file -->
        <html lang="en">
            <head>
                <meta charset="UTF-8" />
                <meta name="viewport" content="width=device-width, initial-scale=1.0" />
                <!-- Style can be set -->
                <style>
                    body {
                        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                    }
                    .table-display-message {
                        border-collapse: collapse;
                    }
                    .table-display-message th {
                        border: 1px solid #d9d9d9;
                        padding: 5px;
                    }
                    .table-display-message td {
                        border: 1px solid #d9d9d9;
                        padding: 5px;
                    }
                </style>
            </head>
            <body>
                <!-- Remember this example for formatting date and time -->
                <h1>Report <xsl:value-of select="format-dateTime(current-dateTime(),'[M01]/[D01]/[Y0001] [H01]:[m01]')" /></h1>
                <p>Total items: <xsl:value-of select="count(/Table/Items/Item)"/></p>

                <h3>Grouped by typology</h3>
                <table class="table-display-message">
                    <thead>
                        <tr>
                            <th>Typology</th>
                            <th>Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each-group select="/Table/Items/Item" group-by="Classification[@key='typology']">
                            <xsl:sort select="Field[@key='titleEn']" order="ascending" data-type="text" />
                            <tr>
                                <td><xsl:value-of select="current-grouping-key()"/></td>
                                <td><xsl:value-of select="count(current-group())"/></td>
                            </tr>
                        </xsl:for-each-group>
                    </tbody>
                </table>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>